/*____________________________________________________________________________
		Copyright (C) 2000 Network Associates, Inc.
        All rights reserved.

        $Id: CPropertySheet.cpp,v 1.2 1999/12/22 10:05:04 nryan Exp $
____________________________________________________________________________*/

#include "pgpClassesConfig.h"

#include "CPropertyPage.h"
#include "CPropertySheet.h"
#include "UModuleInstance.h"

_USING_PGP

// Class CPropertySheet member functions

CPropertySheet::CPropertySheet() : mNumPages(0)
{
}

CPropertySheet::~CPropertySheet()
{
	ClearPages();
}

void 
CPropertySheet::AddPage(CPropertyPage *pPage)
{
	pgpAssertAddrValid(pPage, CPropertyPage);

	pPage->SetVariables(&mError, &mSkipConfirmCancel);
	mPageList.AddTail(pPage);
}

void 
CPropertySheet::RemovePage(CPropertyPage *pPage)
{
	pgpAssertAddrValid(pPage, CPropertyPage);
	mPageList.Remove(pPage);
}

void 
CPropertySheet::ClearPages()
{
	mPageList.Empty();
	mNumPages = 0;
}

void 
CPropertySheet::Create(HWND parent, PGPBoolean isWizard)
{
	pgpAssert(!mPageList.IsEmpty());
	pgpAssert(CWindow::IsWindow(parent));

	pgpClearMemory(&mPSH, sizeof(mPSH));

	mPSH.dwSize		= sizeof(mPSH);
	mPSH.dwFlags	= PSH_HASHELP | PSH_NOAPPLYNOW | 
		(isWizard ? PSH_WIZARD | PSH_WIZARDCONTEXTHELP : 0);
	mPSH.hwndParent	= parent;
	mPSH.hInstance	= UModuleInstance::Get();

	mPageArray.Resize(mPageList.Count());

	CPropertyPage	*pPage	= reinterpret_cast<CPropertyPage *>(
		mPageList.Head());
	PGPUInt32		i		= 0;

	while (IsntNull(pPage))
	{
		mPageArray[i++] = pPage->PageHandle();
		pPage = reinterpret_cast<CPropertyPage *>(mPageList.Next(pPage));
	}

	mPSH.nPages = mPageList.Count();
	mPSH.phpage = mPageArray.Get();

	mError = CComboError();
	mSkipConfirmCancel = FALSE;

	PreCreateHook();

	try
	{
		PGPInt32	result	= PropertySheet(&mPSH);

		if (result == -1)
			THROW_ERRORS(kPGPError_Win32CommCtrlOpFailed, GetLastError());

		if (mError.IsError())
			throw mError;

		ClearPages();
	}
	catch (CComboError&)
	{
		ClearPages();
		throw;
	}
}
